/*
	in_sndfile: sndfile input device
	
	part of DerMixD
	(c)2007-9 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "in/drv/in_sndfile.hxx"
#include <sndfile.h>

#include <string>

#include "debug.hxx"

using std::string;

#define ME "snd_file"

struct snd_file::my_private
{
	SF_INFO info;
	SNDFILE* file;
};

snd_file::snd_file(): input_file(input::sndfile), parts(new struct my_private)
{
	CONSTRUCT(ME);
	parts->file = NULL;
	i_am_fine = true;
}

snd_file::~snd_file()
{
	DESTBEGIN(ME);
	do_close();
	delete parts;
	DESTEND(ME);
}

bool snd_file::do_read(void* buf, size_t wanted_bytes, size_t &got_bytes)
{
	if(parts->file != NULL)
	{
		size_t got_samples = sf_readf_short(parts->file, (short*)buf, format.bytes2samples(wanted_bytes));
		got_bytes = format.samples2bytes(got_samples);
		return true;
	}
	else
	{
		got_bytes = 0;
		return false;
	}
}


bool snd_file::do_open(const string location)
{
	parts->info.format = 0;
	parts->file = sf_open(location.c_str(), SFM_READ, &(parts->info));
	if(parts->file != NULL)
	{
		format.channels = parts->info.channels;
		format.rate = parts->info.samplerate;
		// be prepared for float files read as int (I should work with float in that case...)
		sf_command(parts->file, SFC_SET_CLIPPING, NULL, SF_TRUE);
		sf_command(parts->file, SFC_SET_SCALE_FLOAT_INT_READ, NULL, SF_TRUE);
	}
	return parts->file != NULL;
}

void snd_file::do_close()
{
	if(parts->file != NULL) sf_close(parts->file);
	parts->file = NULL;
}

bool snd_file::do_seek(off_t pos)
{
	if(parts->file != NULL)
	{
		position = (off_t) sf_seek(parts->file, pos, SEEK_SET);
		return (position >= 0);
	}
	else return false;
}

off_t snd_file::do_length(){ return parts->info.frames; }
