#ifndef DMD_H_IN_SINE
#define DMD_H_IN_SINE

/*
	in_sine: sine input file
	
	just a simple tone generator, one channel, one sine wave
	it uses a kindof URL syntax to fake a filename:
	loading of sine://1000@48000 results in a 1000Hz sine wave sampled at 48kHz,
	loading of sine://1000 results in 1000Hz wave sampled at whatever the current sampe rate is
	
	part of DerMixD
	(c)2006-2013 Thomas Orgis, licensed under GPLv2
*/

#include "in/input_file.hxx"

class sine_file: public input_file
{
	protected:
	unsigned long frequency;
	audio_buffer table;
	size_t table_pos;
	bool build_table();

	public:
	sine_file();
	~sine_file();

	bool  do_read(void* buf, size_t wanted_bytes, size_t &got_bytes);
	bool  do_open(const std::string location);
	void  do_close(void);
	bool  do_seek(off_t pos);
	off_t do_length(){ return 0; }
	// In theory, one could easily implement the equalizer here.
	// It may actually make sense when this sine generator is extended to mix several sine signals of different frequencies.
};

#endif
