#ifndef DMD_H_IN_RAW_S16
#define DMD_H_IN_RAW_S16

/*
	in_raw_s16: RAW Stereo 16bit (no thoughts about byte order) input device
	
	part of DerMixD
	(c)2004-7 Thomas Orgis, licensed under GPLv2
	
	This reads from files with RAW data (no audio devices, though If you have a driver that offers a simple device file to read from...).
*/

#include "in/input_file.hxx"
#include <fstream>

class raw_s16_file: public input_file
{
	private:
	std::ifstream file;
	bool opened;

	public:
	raw_s16_file();
	~raw_s16_file();

	bool  do_read(void* buf, size_t wanted_bytes, size_t &got_bytes);
	bool  do_open(const std::string location);
	void  do_close();
	bool  do_seek(off_t pos);
	off_t do_length();
};

#endif
