/*
	in_raw_s16: RAW 16bit (no thoughts about byte order) input device

	part of DerMixD
	(c)2004-7 Thomas Orgis, licensed under GPLv2

	When I support different sample formats than signed 16bit, this input device will be extended...
*/

#include "basics.hxx"
#include <fcntl.h>
#include <sys/types.h>
#include <signal.h>
#include "debug.hxx"
#include "audio/audio_buffer.hxx"
#include "in/drv/in_raw_s16.hxx"
#include "comparse.hxx"

#include "param_init.hxx"

using namespace std;

raw_s16_file::raw_s16_file(): input_file(input::raw_s16), opened(false)
{
	CONSTRUCT("raw_s16_file");
	opened = false;
	i_am_fine = true;
}

raw_s16_file::~raw_s16_file()
{
	DESTBEGIN("raw_s16_file");
	if(opened) file.close();
	DESTEND("raw_s16_file");
}

bool raw_s16_file::do_open(const string filename)
{
	MDEBUG("trying to open %s", filename.c_str());
	file.open(filename.c_str(), ios::in|ios::binary);
	if(file.is_open())
	{
		SDEBUG("success");
		opened = true;
		format.channels = 2;
		format.rate = param.as_ulint("audio_rate");
	}
	return opened;
}

off_t raw_s16_file::do_length()
{
	if(!opened) return -1;

	// We just assume that seeking works..
	file.seekg (0, ios::end);
	off_t len = format.bytes2samples(file.tellg());
	file.seekg(format.samples2bytes(position));

	return len;
}

 //try to seek to data->position, set it to really achieved value, respond to socket
bool raw_s16_file::do_seek(off_t pos)
{
	if(!opened) return false;

	MDEBUG("seeking to %lu", (unsigned long)pos);
	// this fstream sux - seekg doesn't clear eof! In fact, it does nothing on eof...
	if(file.eof()) file.clear();

	file.seekg(format.samples2bytes(pos));
	if(file.good())
	{
		SDEBUG("file still good");
		position = pos;
		return true;
	}
	else return false;
}

bool raw_s16_file::do_read(void* buf, size_t wanted_bytes, size_t &got_bytes)
{
	SDEBUG("read!");
	got_bytes = 0;

	if(!opened) return false;

	if(file.eof())
	{
		SDEBUG("EOF");
		return true;
	}

	// RTFM on the file class... this does not look right.
	// Especially return value of file.read()!
	//off_t start = file.tellg();
	MDEBUG("want bytes: %zu into %p", wanted_bytes, buf);
	file.read((char*) buf, (streamsize) wanted_bytes);
	got_bytes = (size_t) file.gcount();

	return true;
}

void raw_s16_file::do_close()
{
	if(opened) file.close();

	opened = false;
}
