#ifndef DMD_H_IN_libmpg123
#define DMD_H_IN_libmpg123
/*
	in_libmpg123: input of files handled by libmpg123
	
	part of DerMixD
	(c)2007-2010 Thomas Orgis, licensed under GPLv2
*/

#include "in/input_file.hxx"

class libmpg123_file: public input_file
{
	private:
	void* handle;

	public:
	libmpg123_file();
	~libmpg123_file();
	bool do_read(void* buf, size_t wanted_bytes, size_t &got_bytes);
	bool do_open(const std::string location);
	void do_close(void);
	bool do_seek(off_t pos);
	off_t do_length(void);
	bool do_eq(const std::vector<float> &val);
};

#endif
