/*
	in_dummy: dummy input device
	
	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "audio/audio_buffer.hxx"
#include "mathhelp.hxx"
#include "in/drv/in_dummy.hxx"

#include "debug.hxx"

using namespace std;

// Wondering: Is the constructor run any time here?
static audio_format dummy_format(44100, 2);
static off_t dummy_length = 128*1024; // 128K dummy data size.

#define ME "dummy_file"

dummy_file::dummy_file(): input_file(input::dummy), filepos(0)
{
	CONSTRUCT(ME);
	i_am_fine = true;
}

dummy_file::~dummy_file()
{
	DESTRUCT(ME);
}

bool dummy_file::do_read(void* buf, size_t wanted_bytes, size_t &got_bytes)
{
	got_bytes = min(wanted_bytes, (size_t)(filepos-dummy_length));
	memset(buf, 0, got_bytes);
	filepos += got_bytes;
	return true;
}

bool dummy_file::do_open(const string location)
{
	MDEBUG("loading file %s", location.c_str());
	format.rate = dummy_format.rate;
	format.channels = dummy_format.channels;
	filepos = 0;

	return true;
}

void dummy_file::do_close(void)
{
	SDEBUG("closing");
}

bool dummy_file::do_seek(off_t pos)
{
	filepos = min(format.samples2bytes(pos), dummy_length);
	position = format.bytes2samples(filepos);
	return true;
}

off_t dummy_file::do_length(void)
{
	return format.bytes2samples(dummy_length);
}
