#ifndef DMD_H_FILE_TYPE
#define DMD_H_FILE_TYPE

/*
	file_type: Determine (input) file type.

	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2

	Main result is a std::string that corresponds to the type std::string of an input_file class. Note that I do not refer to the actual input_file classes here, the type std::strings just should match up. I opted for better separation of code.
*/

#include <string>
#include "in/input_file_types.hxx"

namespace input
{

class file_type
{
	private:
	struct my_private;
	struct my_private* parts;

	protected:
	// Extract file name ending, protected so that a subclass can access it in a test.
	const std::string ending(const std::string filename);
	// Parse (pseudo-) URLs, extract the bla out of bla://blu.
	const std::string prefix(const std::string filename);
	// Same for guessing MIME type.
	const std::string mime_guess(const std::string filename);
	type_id mime_to_type(const std::string mime);
	type_id ending_to_type(const std::string ending);

	public:
	 file_type();
	~file_type();
	// This compiles the magic database. It is not done in the constructor because it may take some time. Better call explicitly in a worker thread.
	void prepare();
	// Guess a corresponding class type std::string.
	type_id guess(const std::string filename);
};

}
#endif
