#ifndef DMD_H_ERRORCODES
#define DMD_H_ERRORCODES

/*
	errorcodes: Collect and enumerate (in future) all error situations in DerMixD.

	part of DerMixD
	(c)2009-2010 Thomas Orgis, licensed under GPLv2
*/

namespace dmd
{
namespace err
{

enum codes
{
	// We store signed integers, so make this clear here.
	 INVALID = -1
	,NOTHING = 0
	// Those are taken from old action_erros.h
	,DEVERR
	,BUSY
	,UNKNOWN_COMMAND
	,BAD_CHANNEL
	,IN_FOLLOW_ANOTHER
	,BAD_STATE
	,NONSENSE
	,NO_DEVICE // No underlying device (or similar...).
	,LOADERR
	,NOT_SUPPORTED
	,BAD_FILE
	,NOMEM
	,IO      // Some I/O problem.
	,BAD_PAR // Bad parameters given.
	,SETUP   // Some setup code failed.
	,BAD_PEER // No peer of that name.
	,SOMETHING // just some kind of error
	,TODO // Some missing bit in the implementation.
};

}
}

#endif
