/*
	daemon: Become a daemon process.
	
	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2
	
	I need to remember where I grabbed the exact workings of this from. I've read several documents on how to properly fork in the background, I suppose... but I don't remember currently why I needed to double-fork.
	Trying the simple one-fork by-the-book routine now...
	
	Note: There is a libc daemon function available with glibc (Linux) and (some?) BSDs... but it's not POSIX.
*/

// Using system stuff directly, without dermixd basics... this file is rather ground-level in itself.
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>

#include <errno.h>
#include <string.h>

#include <string>
using std::string;

#include "debug.hxx"

static bool check_file(const char *name)
{
	int test_fd = open(name, O_WRONLY|O_CREAT|O_TRUNC, 0666);
	if(test_fd < 0)
	{
		MERROR("[daemonize] Daemon output file '%s' is not accessible: %s", name, strerror(errno));
		return false;
	}
	close(test_fd);
	return true;
}

bool daemonize(const string stdout_file, const string stderr_file)
{
	MDEBUG("[daemonize] Startup from pid %i, using output file '%s'.", (int)getpid(), stdout_file.c_str());

	// First, try if the daemon output can be opened.
	// It's nasty to try to recover from that error after forking...
	if(!check_file(stdout_file.c_str()) || !check_file(stderr_file.c_str()))
	{
		SERROR("[daemonize] Output files are not good. Sorry.");
		return false;
	}

	// Fork a child.
	int pid = (int)fork();
	if(pid < 0)
	{
		MERROR("[daemonize] Fork failed: %i %s", pid, strerror(errno));
		return false;
	}

	// End the parent's life.
	if(pid != 0) exit(0);

	MDEBUG("[daemonize] This is the daemon child, with pid %i.", (int)getpid());

	// Get independent from tty and found an own gang.
	setsid();

	// The tty has nothing to tell us anymore... also no standard I/O paths.
	close(STDIN_FILENO);
	close(STDOUT_FILENO);
	close(STDERR_FILENO);

	// Open standard file descriptors (0,1,2) in order.
	// Standard input comes from nowhere...
	// I won't deal with failure here.
	if(open("/dev/null", O_RDONLY) < 0) exit(2);
	if(open(stdout_file.c_str(), O_WRONLY|O_CREAT|O_TRUNC, 0666) < 0) exit(3);
	if(open(stderr_file.c_str(), O_WRONLY|O_CREAT|O_TRUNC, 0666) < 0) exit(4);

	// Go to a safe place, after opening the output file (could be local path).
	chdir("/");

	// ignore SIGHUP that will be sent to a child of the process
	// Is that essential? When will the signal arrive?
	//signal(SIGHUP, SIG_IGN);

	// Why?? I faintly remember this second fork() having some idea behind it... but what was it?
	// Something with signals?
	// pid = fork();
	// if(pid < 0) return false; // Unable to create another child...
	// if(pid != 0) exit(0);

	// Ignore SIGPIPE, for reading, writing to non-opened pipes.
	// I might ditch this one once I stopped using external decoders... or do I want to retain that possibility?
	// HTTP streaming wia external process might be an idea... 
	//signal(SIGPIPE, SIG_IGN);

	// Success!
	return true;
}
