#ifndef DMD_H_SPIES
#define DMD_H_SPIES
/*
	spies: list of communicators spying on all communication

	part of DerMixD
	(c)2008 Thomas Orgis, licensed under GPLv2
*/

#include "threads/readwrite_barrier.hxx"
namespace dmd { class socket_writer; }

#include <string>
#include <vector>

class spies
{
	private:
	dmd::readwrite_barrier barrier;
	// Those are the spying socket writers.
	std::vector<dmd::socket_writer*> them;
	// Give copies of msg to all spies, except the collaborateur himself.
	void hand_over(const std::string &msg, int id);

	public:
	// A little optimization for empty spies list: The flag is false when no spies are there.
	bool active;
	spies();
	~spies();

	// Call that before handing over any messages.
	void call_em(){ barrier.reading(); };
	// Those two wrappers should be used to hand over incoming/outgoing messages.
	void hand_over_incoming(const std::string &msg, int id);
	void hand_over_outgoing(const std::string &msg, int id);
	// Call that after messages have been sent over.
	void hang_up(){ barrier.done_reading(); };

	// And these are the changes:
	void send(dmd::socket_writer* spy); // Add spy to spies list (if not already there).
	void eliminate(dmd::socket_writer* spy); // Remove the at most one occurence of that socket writer in spies list.
	void eliminate_all(); // ...
};

#endif
