/*
	spies: list of communicators spying on all communication

	part of DerMixD
	(c)2008-9 Thomas Orgis, licensed under GPLv2
*/
#include "basics.hxx"
#include "coms/socket_writer.hxx"
#include "coms/spies.hxx"
#include "tstring.hxx"

#include <string>
#include <vector>

#include "shortcuts.hxx"
#include "debug.hxx"

using std::string;
using std::vector;

#define ME "spies"

spies::spies(): active(false)
{
	CONSTRUCT(ME);
}

spies::~spies()
{
	DESTRUCT(ME);
}

void spies::hand_over_incoming(const string &msg, int id)
{
	std::string ts;
	strprintf(ts, "[spy %i in] ", id);
	ts += msg;
	hand_over(ts, id);
}

void spies::hand_over_outgoing(const string &msg, int id)
{
	std::string ts;
	strprintf(ts, "[spy %i out] ", id);
	ts += msg;
	hand_over(ts, id);
}

void spies::hand_over(const std::string &msg, int id)
{
	FOR_VECTOR(dmd::socket_writer*, them, s)
	if((*s)->id != id){ (*s)->write_copy(msg, true); }
}

void spies::send(dmd::socket_writer* spy)
{
	vector<dmd::socket_writer*>::iterator i;
	barrier.reading();
	for(i=them.begin(); i!=them.end(); ++i)
	if(*i == spy) break;
	barrier.done_reading();

	if(i == them.end())
	{
		barrier.writing();
		them.push_back(spy);
		active = true;
		barrier.done_writing();
	}
}

void spies::eliminate(dmd::socket_writer *spy)
{
	barrier.writing();
	for(vector<dmd::socket_writer*>::iterator i=them.begin(); i!=them.end(); ++i)
	if(*i == spy)
	{
		them.erase(i);
		break;
	}
	if(them.empty()) active = false;
	barrier.done_writing();
}

void spies::eliminate_all()
{
	barrier.writing();
	them.clear();
	active = false;
	barrier.done_writing();
}
