#ifndef DMD_H_SOCKETEER
#define DMD_H_SOCKETEER

/*
	socketeer: The thread communicating with clients (usually via a socket).
	
	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
	
	Actual reading/writing is channeled through socket_buffer.
*/

#include "action.hxx"
#include "threads/threads.hxx"
#include "coms/socket_writer.hxx"
#include "coms/client_action_handler.hxx"

#include <string>

namespace dmd
{

class socket_watch;

// For socketeer data... avoiding dynamic data in threads.
#define SCRATCH_CHARS 29

//data for a socketeer...
class socketeer: public thread
{
	// Initialization order needs that here...
	private: socket_buffer sb; // Input socket buffer.

	public:
	int id; // The socket, actually.
	socket_writer writer; // associated writer thread

	// Start operation on a socket, which will be taken over completely.
	 socketeer(int sock, socket_watch &mummy);
	// Start operation on in/out plain files (keeping the descriptors open after destruction).
	 socketeer(int in_fd, int out_fd, socket_watch &mummy);
	~socketeer();

	void thread_work();

	private:
	std::string ms; // Safe storage for input messages.
	socket_watch *mum;
	comm_data cd; // Commnunication with mixer thread.
	client_action_handler actor;
};

}
#endif
