#ifndef DMD_H_SOCKET_WRITER
#define DMD_H_SOCKET_WRITER

/*
	socket_writer: The thread that is responsible for writing on a socket.
	This is separate from the thread reading on the socket, to ease blocking operation. Yes, I'm rather quick on creating new threads here...
	
	part of DerMixD
	(c)2005-2009 Thomas Orgis, licensed under GPLv2
	
	depends on netcomm.h to provide actual socket reading/writing
*/

#include "coms/netcomm.hxx"
#include "threads/threads.hxx"
#include "mutex.hxx"
#include "threads/semaphore.hxx"
#include <string>
#include <vector>

// Need to have that predeclared here, because of circular header dependency!
class spies;

namespace dmd {

// One message... grouped with a spy flag.
// The flag is there to mark messages that result from spying on others -- those secret messages are not handed over to the spies again (that would make for nice endless looping).
class swm
{
	public:
	// Just a pointer to the message string -- someone else cares about allocation and deletion.
	std::string *msg;
	bool spied;
	swm(std::string *ms, bool spy): msg(ms), spied(spy) {};
	~swm(){};
};

class socket_writer: public thread
{
	public:

	int id;
	real_mutex lock;
	semaphore semo;
	socket_buffer *sink;
	spies *bnd;

	bool is_end;

	std::vector<swm> messages;

	socket_writer(socket_buffer &mysink, spies &mybnd);
	~socket_writer();

	// First variant for writing a message string is also the only one that supports spying.
	// Generally, the socket_writer takes control over the memory for the messages it stores -- use the _copy routines to retain caller's instance of the message string object(s).
	void write_copy(const std::string &msg, bool spy=false);
	void write_copies(std::vector<std::string*> &msgs);
	void write(std::string *msg, bool spy=false);
	void writes(std::vector<std::string*> &msgs);
	// Flush messages down the sink.
	void flush();
	// This needs to be called before destructing the socket writer.
	// It kills the thread and flushes all remaining messages.
	void end();
	void thread_work();
};

}
#endif
