#ifndef DMD_H_NETCOMM
#define DMD_H_NETCOMM

/*
	netcomm: tcp and unix port watching and basic socket communication

	part of DerMixD
	(c)2004-2012 Thomas Orgis, licensed under GPLv2
	
	initial tcp code derived from:
	
	netcomm.c for mixplayd
	
	provides functions for communiction on a tcp socket
	(c) Siegfried Wagner 01/06/27
	
	license: GNU General Public License (GPL)
	         For details see the file COPYING included with this archive
	last update: 01/08/28 by Siegfried Wagner
*/

#include "basics.hxx"

// Hacking for Tru64 ... I need to revisit that again. Untested.

#ifdef WANT_PORT_T
typedef in_port_t porttype;
#else
typedef uint16_t porttype;
#endif

#include <string>

//beware of cancellation points... does capsulation of reading prevent this?

#define MAX_MSG_LENGTH 10000
#define MSG_BUF_SIZE 1024

namespace dmd { class thread; }

class socket_buffer
{
	private:
	char buf[MSG_BUF_SIZE];
	int pos;
	ssize_t fill;
	bool close_on_end; // close descriptors in destructor

	public:
	// Theoretically, this should be a private variable, but I use it as ID to distinguish sockets (or the socketeer threads, actually).
	// Of course I can fix that some time...
	int insock;
	int outsock;

	socket_buffer(int in_fd, int out_fd = -1, bool close_on_end=true);
	~socket_buffer();
	
	// If a thread is provided, it is made cancelable  while blocking for I/O.
	// Returns 
	int read_line(std::string& msg, dmd::thread *ted = NULL); //doesn't include the "\n"!
	int write_exactly(std::string& msg); //doesn't automatically append "\n"
	int writeln(std::string& msg); //does automatically append "\r\n"
};

class socket_listener
{
protected:
	int sock;
public:
	bool online; // Check this after construction. If false, the socket failed to come up.
	socket_listener(void);
	virtual ~socket_listener();
	virtual int accept_connection(dmd::thread *ted = NULL);
};

class port_listener: public socket_listener
{
public:
	port_listener(porttype port_number, bool remote);
	~port_listener();
};

class unix_listener: public socket_listener
{
private:
	std::string sockname;
public:
	unix_listener(const std::string name);
	~unix_listener();
};

#endif
