#ifndef DMD_H_COMM_DATA
#define DMD_H_COMM_DATA

/*
	comm_data: simple return value/error back transport with semaphore for notifying initiator of action
	
	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2

	This also embodies a mutex, to help the mixer_worker, mainly. This one does not actually trigger and wait for the actions it receives the errors for. Thus, we have possible non-determinism in access to the comm_data.
*/

#include <vector>
#include <string>

#include "errorchain.hxx"

class semaphore;
#include "mutex.hxx"

class comm_data: public optional_mutex
{
	private:
	bool mysem;

	public:
	semaphore * waitress; // Shouldn't comm_data _be_ an optional semaphore, too?
	errorchain errors; // A chain of inconvenient events.
	// Return values are ugly, will be fixed later, though.
	float retval;
	unsigned long int retval_ulong;
	unsigned long int retval_ulong2;
	// Strings you push to that vector will be deleted by comm_data.
	std::vector<std::string*> retlines;

	// Possibly providing am outside semaphore and
	// an actual mutex to use. Semaphore is allowed to be NULL.
	comm_data(semaphore *s = NULL, mutex *mutti = NULL);
	//comm_data(pthread_t * t);
	~comm_data();

	void clear(); //clear the communication data (_not_ waitress and thread!)
};

#endif
