/*
	comm_data: simple return value/error back transport with semaphore for notifying initiator of action
	
	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2
*/

#include "coms/comm_data.hxx"
#include "threads/semaphore.hxx"
#include "tstring.hxx"

#include "shortcuts.hxx"
#include "debug.hxx"

using namespace std;

#define ME "comm_data"

comm_data::comm_data(semaphore *s, mutex *mutti): optional_mutex(mutti)
	,mysem(s == NULL), waitress(s ? s : new semaphore)
	,retval(0.), retval_ulong(0), retval_ulong2(0)
{
	CONSTRUCT(ME);
}

comm_data::~comm_data()
{
	DESTBEGIN(ME);
	clear();
	if(mysem)
	{
		MDEBUG("destroying semaphore %p", (void*) waitress);
		delete waitress;
	}
	DESTEND(ME);
}

void comm_data::clear()
{
	errors.clear();
	retval = 0.;
	retval_ulong = 0;
	retval_ulong2 = 0;

	FOR_VECTOR(std::string*, retlines, i) delete *i;

	retlines.clear();
}
