#ifndef DMD_H_CLIENT_API
#define DMD_H_CLIENT_API

/*
	client_api: The action definitions that matter to DerMixD clients.
	
	part of DerMixD
	(c)2006-2012 Thomas Orgis, licensed under GPLv2
	
	This used to be a collection of the externally relevant actions only, but has been extended by the few extra action definitions for internal use.
*/

#include "action.hxx"

namespace dmd
{
namespace api
{

// Those are the actions that have some external meaning,
// i.e. they can be parsed from client strings.
extern const def client_world[];

// Some specific actions for direct access.
// Actually ... the first two appear unused.
extern const def in_start;
extern const def out_start;
extern const def in_script;
extern const def in_nscript;

// Create an action for one-time use from a client string.
// Any diagnostics and return values persist in cd, if given.
// The action is also marked as disposable.
// On error (includes parsing), NULL is returned.
action* one_time_act(const std::string clientstring, comm_data *cd = NULL);

// Create an action for notifying about completion of given base action.
// Didn't think of a better place right now ... this will vanish anyhow
// once channels get more emancipated about their own state.
// A notify action is disposable by definition. A copy of the base_act will
// be included, also being destructed with the notifucation.
// Communication data will not be copied in the sub action.
action* make_notify_act(action *base_act);

}
}
#endif
