#ifndef DMD_H_CLIENT_ACTION_HANDLER
#define DMD_H_CLIENT_ACTION_HANDLER

/*
	client_action_handler: The code to process client actions, from parsing to sending to mixer, waiting for response... storing messages to be sent back to clients.

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2

	This is separated out of the socketeer to add full action handling for startup script and possibly other occasions in future.
	A little complication is that this code shall work with optional cancellation points for the calling thread.
*/

#include <string>
#include <vector>

#include "action.hxx"
#include "browse.hxx"

class thread;
class socket_writer;

namespace dmd
{

class socket_watch;
class actionlist;

class client_action_handler
{
	public:
	// Any messages produced 
	std::vector<std::string*> answers;
	// A flag to indicate we encountered a final action.
	bool got_final;
	bool got_error;
	// Constructor to call from a socketeer.
	// This enables cancellation points and actions that work on the socket_watch (like peer communication).
	 client_action_handler(thread &cancelee, socket_writer &writer, socket_watch &watch);
	// Constructor for simpler contexts; disabling communicative actions.
	// Just working with the agent behind the action list.
	 client_action_handler(thread &cancelee, actionlist &actions);
	~client_action_handler();

	// Interpret one command string and do the actions it demands.
	// Any normal output as well as error messages are put into the answers vector (pushed to the back, not clearing automatically).
	// Apart from parsing the answer strings (bad idea), you have the return value to know if there was some issue with handling the command.
	// The string must be handed in by reference to a real non-temporary object so that its memory won't leak when being cancelled during handling.
	// Makes me wonder if it should be a char* instead...
	void handle(const std::string &cmd);

	private:
	// Action and communication data structures are local here,
	// but destination of async messaging (socket_writer) is handed in.
	action act;
	comm_data cd;
	std::string ans;
	// Client handling includes file browsing.
	browser bro;
	actionlist *actions;
	thread *cancelee;
	socket_writer *writer;
	socket_watch *watch;
	bool feedback; // flag for waiting for mixer feedback or not

	void init();
	void handle_command(const std::string &cmd);
	bool postprocess_action();
	void handle_mixer_action();
	void handle_local_action();
	void give_error(const std::string);
};

}
#endif
