#ifndef DMD_H_COMPARSE
#define DMD_H_COMPARSE

/*
	comparse: parsing of command strings (ripping them apart)
	
	part of DerMixD
	(c)2004/5 Thomas Orgis, licensed under GPLv2
	
	I want to avoid strtok and ... I really, really miss PERL here!
*/

#include <vector>
#include <string>

// command/argument separator characters
extern const char* argsep;

//get first token of std::string (the command)
bool commando(const std::string& str, std::string& brok);

//get number arguments in the std::string (ignoring the first one being the command) 
bool argo(const std::string& str, std::vector<std::string>& tokens, const unsigned int& number);

// Split std::string at whitespaces.
void split(const std::string& str, std::vector<std::string>& tokens, const std::string sep=argsep);

#endif
