/*
	comparse: parsing of command strings (ripping them apart)
	
	part of DerMixD
	(c)2004/5 Thomas Orgis, licensed under GPLv2
	
	I want to avoid strtok and ... I really, really miss PERL here!
*/

#include <string>
#include <vector>
#include <iostream>

using namespace std;

// Commands and arguments are separated by whitespace, i.e. " " and tabs.
const char* argsep = " \t";

/*
	try to split string _after_ first token into <number> pieces separated by spaces
puts the found tokens into <tokens> and returns true if parsing was successful (enough spaces found...)

	sense of <number>: "load 0 the filename with spaces" should be parsed into 3 tokens, not 6
*/
bool argo(const string& str, vector<string>& tokens, const unsigned int& number)
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(argsep, 0);
	// Skip first token (search for next whitespace)
	string::size_type pos = str.find_first_of(argsep, lastPos);
	tokens.clear();
	if(number == 0) return true;
	if(pos != string::npos)
	{
		lastPos = str.find_first_not_of(argsep, pos);
		// Find first "non-delimiter".
		pos = str.find_first_of(argsep, lastPos);

		while((tokens.size() < number-1) && (string::npos != pos || string::npos != lastPos)) //while one of these position is valid...
		{
			// Found a token, add it to the vector.
			tokens.push_back(str.substr(lastPos, pos - lastPos));
			// Skip delimiters.  Note the "not_of"
			lastPos = str.find_first_not_of(argsep, pos); //finds first non-delimiter... lastPos = start of new stuff or npos
			// Find next "non-delimiter"
			pos = str.find_first_of(argsep, lastPos); //next delimiter after start
		}

		if(lastPos != string::npos)
		{
			tokens.push_back(str.substr(lastPos));
			if(tokens.size() == number) return true;
			else return false;
		}
		else return false;
	}
	else return false;
}

//simple variant just putting the first token into <brok>
bool commando(const string& str, string& brok)
{
	string::size_type lastPos = str.find_first_not_of(argsep, 0);
	// Find first "non-delimiter".
	if(string::npos != lastPos)
	{
		brok = str.substr(lastPos, str.find_first_of(argsep, lastPos)-lastPos);
		return true;
	}
	else return false;
}

/*
	Just split it into as many pieces as possible.
	Looks quite redundant to argo.
*/
void split(const string& str, vector<string>& tokens, const string sep)
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(sep, 0);
	// Find first "non-delimiter".
	string::size_type pos = str.find_first_of(sep, lastPos);
	while(string::npos != pos || string::npos != lastPos) //while one of these position is valid...
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(sep, pos); //finds first non-delimiter... lastPos = start of new stuff or npos
		// Find next "non-delimiter"
		pos = str.find_first_of(sep, lastPos); //next delimiter after start
	}

	if(lastPos != string::npos)
	tokens.push_back(str.substr(lastPos));
}


