#ifndef DMD_H_CHANNEL
#define DMD_H_CHANNEL

/*
	channel: generic code for in/output mixer channels
	
	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
*/

// Make sure reorderings in the enums are reflected in state_text()!

#include "action.hxx"
#include "threads/threads.hxx"
#include <string>
#include <vector>

namespace dmd
{

typedef struct timeaction
{
	float time;
	long  count;
	action *act;
} timeaction;

class channel: public thread_container
{
	public:

	// The channel ID is of size_t because it relates to the offset in the channel list.
	// You are supposed to manage it from the outside.
	size_t id;

	bool working;
	bool offline;

	enum statecode
	{
		 NOTHING = -1
		,DEAD = 0 
		,PLAYING // Actively decoding.
		,PAUSED  // File loaded, playback on hold.
		,NODEV   // No actual decoder there.
		,IDLE    // Device there and no file loaded
		,SEEKING_PAUSE // Currently seeking, going into PAUSED when done.
		,SEEKING_PLAY  // Currently seeking, resuming playback when done.
		,LOADING       // Currently loading a file (without further action, PAUSED should follow).
	};
	// Textual representation of the status 
	const char* state_text();
	enum statecode status;

	std::string name;
	std::vector<timeaction> script;
	std::vector<timeaction> postscript;

	channel(const size_t idv, const std::string namev);
	virtual ~channel();

	virtual void now_and_then(size_t chunksize, float &now, float &then) = 0;

	// Script stuff is here although there is only input scripting... yet.
	// There is the possibility to make scripting support on output complete.
	bool getactions(unsigned int chunksize, std::vector<action*> &nowscript);
	std::vector<timeaction>::size_type addaction(const double time, const long count, action*);
	void delscript();
	void script_nirvana(socket_writer* dead_writer);
	bool getpostactions(std::vector<action*> &nowscript);
	// Man, do I really want to play that game? Not just size_t?
	std::vector<timeaction>::size_type addpostaction(const double time, const long count, action*);
	// Still have a setter routine for the ID here... there could be funky stuff happening on change (it's a constructor argument, at last).
	virtual void set_id(const size_t idv);
};

} // namespace

// Pre-declarations of both channel types, so that the special definitions can rely on each other.
class inchannel;
class outchannel;
#endif
