#ifndef DMD_H_BROWSE
#define DMD_H_BROWSE
/*
	browse: support some cd, ls, pwd
	
	part of DerMixD
	(c)2007-2010 Thomas Orgis, licensed under GPLv2
	
	This might become part of the socketeer class... or the cwd member of socketeer gets blown up into a filesystem object.
*/

#include <string>
#include <vector>

namespace dmd
{

class browser
{
	public:
	 browser();
	~browser();
	// what: list of files/directories to list (may be modified if empty, to include ".".
	// listing: The file/dir listing, formatted for clients.
	void browse(std::vector<std::string> &what, std::vector<std::string*> &listing);
	// Store current working directory, if there is one (check return value).
	bool pwd(std::string &workdir);
	// Change to specified directory (return success).
	bool change_dir(const std::string path);
	// If the file is accessible in current working dir, make the path absolute.
	// If it's no accessible file, we assume some kind of URL (so one might want to reconsider the situation where you meant some URL but hit a local file).
	void adjust_path(std::string &path);

	private:
	char *cwd;
	void update_cwd();
};

// The named file in given directory is an existing file.
bool existing_file(const std::string name, const std::string dir = ".");
// Find files in given directory, ending with given suffix and returned names being stripped of which.
void suffix_files(const std::string dir, std::vector<std::string*> &files, const std::string suffix = "");

}

// A bit out of place... it's filesystem related, at least.
// Read through a file once to get it into the filesystem cache.
off_t read_file(const std::string &name);

#endif
