// This file hosts the definitions of factory functions for the different output file classes.
// This code is inlined in file_types.cxx, the actual factory.
// The names of the functions here (or macros in case of optional types) must match up with the third argument to X() in the type list (output_types.hxx).

#include "out/drv/out_dummy.hxx"
static output_file* new_out_dummy(){ return new dummy_output(); }

#ifdef OUT_OSS
#include "out/drv/out_oss.hxx"
static output_file* new_out_oss(){ return new oss_output(); }
#define NEW_OSS new_out_oss
#else
#define NEW_OSS NULL
#endif

#ifdef OUT_MME
#include "out/drv/out_mme.hxx"
static output_file* new_out_mme(){ return new mme_output(); }
#define NEW_MME new_out_mme
#else
#define NEW_MME NULL
#endif

#ifdef OUT_ALSA
#include "out/drv/out_alsa.hxx"
static output_file* new_out_alsa(){ return new alsa_output(); }
#define NEW_ALSA new_out_alsa
#else
#define NEW_ALSA NULL
#endif

#include "out/drv/out_text.hxx"
static output_file* new_out_text(){ return new text_output(); }
#include "out/drv/out_raw_s16.hxx"
static output_file* new_out_raw_s16(){ return new raw_s16_output(); }
