// This file hosts the definitions of factory functions for the different input file classes.
// This code is inlined in file_types.cxx, the actual factory.
// The names of the functions here (or macros in case of optional types) must match up with the third argument to X() in the type list (input_types.hxx).

#include "in/drv/in_dummy.hxx"
static input_file* new_in_dummy(){ return new dummy_file(); }

#include "in/drv/in_sine.hxx"
static input_file* new_in_sine(){ return new sine_file(); }

#include "in/drv/in_raw_s16.hxx"
static input_file* new_in_raw_s16(){ return new raw_s16_file(); }

#ifdef IN_LIBMPG123
#include "in/drv/in_libmpg123.hxx"
static input_file* new_in_mpg123(){ return new libmpg123_file(); }
#define NEW_MPG123 new_in_mpg123
#else
#define NEW_MPG123 NULL
#endif

#ifdef IN_VORBISFILE
#include "in/drv/in_vorbisfile.hxx"
static input_file* new_in_vorbisfile(){ return new vorbis_file(); }
#define NEW_VORBISFILE new_in_vorbisfile
#else
#define NEW_VORBISFILE NULL
#endif

#ifdef IN_SNDFILE
#include "in/drv/in_sndfile.hxx"
static input_file* new_in_sndfile(){ return new snd_file(); }
#define NEW_SNDFILE new_in_sndfile
#else
#define NEW_SNDFILE NULL
#endif
