/*
	file_switch: Select a specific file.

	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2

	This is a template thingy, to be included from elsewhere, inside the input or output namespace.
*/

/* namespace input { */

static FILE_TYPE* new_file(type_id type)
{
	if(!good_id(type)) return NULL;

	if(creator[type] != NULL) return creator[type]();
	else
	{
		MDEBUG("Type %s not built in.", names[type]);
		return NULL;
	}
}

bool type_available(const type_id id)
{
	if(!good_id(id)) return false;

	if(creator[id] == NULL) return false;

	return true;
}

bool switch_file(FILE_TYPE* &file, const type_id type)
{
	string type_name = id_to_name(type);

	MDEBUG("Need type: %s", type_name.c_str());

	if(file != NULL)
	{
		if(file->type == type)
		{
			SDEBUG("File has correct type already.");
			return true;
		}
		else
		{
			SDEBUG("File has wrong type, deleting.");
			delete file;
			file = NULL;
		}
	}

	// Now file has to be NULL.

	if(!good_id(type))
	{
		SDEBUG("You gave me a bad type...");
		return false;
	}

	MDEBUG("Going to create a new input device with type %s.", type_name.c_str());
	file = new_file(type);
	if(file == NULL)
	{
		MDEBUG("Failed to create new input file for type %s!", type_name.c_str());
		return false;
	}

	return true;
}

/* } ... namespace */
