// The header definitions for the common functions (methods) of an enum map.
// You are supposed to include that inside a namespace definition.

// Those need to be defined in the accompanying source...
extern const char* invalid_name;
extern const char* names[count];

// Check if an ID valid is a good value ... that is not totally superfluous with the type checking.
// Namely, the invalid id is valid in the type system but still not good.
bool good_id(enum type_id tid);

// Map string value to ID. Consider turning this into const char* argument?
// Also: if you want case-insensitive match, take care of that on the outside (normalize to lower/uppercase).
enum type_id name_to_id(const std::string name);

// Map ID value to string.
const char* id_to_name(enum type_id tid);
