// I want to build a static enum from/to string mapping, avoiding dynamic memory.
// This building block provides the "methods" of such a mapping.
// I will figure out a way that avoids the cruft and just makes you define name-id pairs -- perhaps via preprocessor magic (among others, X-macros) or just a script generating the enum namespaces.

// Usage outline follows...

// namespace mythings
// {
// 	enum type_id
// 	{
// 		 invalid=-1
// 		,first
// 		,...
// 		,last
// 		,count
// 	};
// 	const char* names[count] =
// 	{
// 		 "first name"
// 		,...
// 		,"last name"
// 	};
// 	const char* invalid_name = "invalid";
//
// Now include this header for the functionality... using the data structures defined above:
	bool good_id(enum type_id tid){ return (tid >= 0 && tid < count); }

	enum type_id name_to_id(const std::string name)
	{
		for(int tid=0; tid < count; ++tid)
		if(name == names[tid]) return (enum type_id)tid;

		return invalid;
	}

	const char* id_to_name(enum type_id tid)
	{
		if(good_id(tid)) return names[tid];
		else return invalid_name;
	}

// End the namespace
// }
