#ifndef DMD_H_SCANNER
#define DMD_H_SCANNER
/*
	scanner: Scanner infrastructure and simple scanner implementations.

	Scanners are used to compute arbitrary properties from an audio stream, which they get fed via pieces one after another.
	To have only one decoding/reading pass, all scanners are applied on the pieces in turn, not to the whole file in turn.

	part of DerMixD
	(c)2008-9 Thomas Orgis, licensed under GPLv2
*/

#include "audio/audio_buffer.hxx"
#include "in/input_state.hxx"
#include <string>

class scanner
{
	public:
	audio_format *fmt;
	scanner(){};
	virtual ~scanner();
	virtual void scan(mixer_buffer &sb) = 0;
	virtual void report(std::string &rs) = 0;
	virtual void update_input(input_state *state){};
};

scanner* create_scanner(const std::string &key, audio_format *f);

class noname_scanner: public scanner
{
	private: std::string name;
	public:
	noname_scanner(const std::string nm);
	~noname_scanner(){};
	void scan(mixer_buffer &sb){};
	void report(std::string &rs);
};

// Scan for peak volume (reports a float value scaled to 1=AUDIO_MAX).
class peak_scanner: public scanner
{
	private: audio_type peak; // In future: separate peaks for channels?
	public:
	peak_scanner(){ peak=0; };
	~peak_scanner(){};
	void scan(mixer_buffer &sb);
	void report(std::string &rs);
};

// Scan for raw number of samples.
class length_scanner: public scanner
{
	private: unsigned long length;
	public:
	length_scanner(){ length=0; };
	~length_scanner(){};
	void scan(mixer_buffer &sb);
	void report(std::string &rs);
	void update_input(input_state *state);
};

// Scan for format.
class format_scanner: public scanner
{
	public:
	format_scanner(){};
	~format_scanner(){};
	void scan(mixer_buffer &sb){};
	void report(std::string &rs);
};

#endif
