/*
	scanner: Scanner infrastructure and simple scanner implementations.

	part of DerMixD
	(c)2008 Thomas Orgis, licensed under GPLv2
*/

#define DMD_NEED_AUDIO_AMP

#include "common.hxx"
#include "audio/scanner.hxx"
#include "audio/scan_power.hxx"
#include "tstring.hxx"

#include <cmath>
#include <string>

using namespace std;

scanner* create_scanner(const string &key, audio_format *f)
{
	scanner* ret = NULL;
	if     (key == "length") ret = new length_scanner();
	else if(key == "peak")   ret = new peak_scanner();
	else if(key == "format") ret = new format_scanner();
	else if(key == "power")  ret = new power_scanner(f);
	else ret = new noname_scanner(key);

	ret->fmt = f;
	return ret;
}

scanner::~scanner(){} // Sense... something with vtable?

noname_scanner::noname_scanner(const string nm)
{
	name = nm;
}

void noname_scanner::report(std::string &rs)
{
	rs = name + ": error: no such scanner";
}


void peak_scanner::scan(mixer_buffer &sb)
{
	for(size_t s=0; s < sb.fill*sb.channels; ++s)
	{
		audio_type cur = audio_amp(sb.ptr[s]);
		if(cur > peak) peak=cur;
	}
}

void peak_scanner::report(std::string &rs)
{
	double vol = audio_vol(peak);
	strprintf(rs, "peak: %g (%g)", vol, peak);
	if(vol > 0) strprintf(rs, ", %g dBFS", audio_vol2dbfs(vol));
}

void length_scanner::scan(mixer_buffer &sb)
{
	length += sb.fill;
}

void length_scanner::report(std::string &rs)
{
	strprintf(rs, "length: %lu samples", length);
}

void length_scanner::update_input(input_state *state)
{
	state->set_length(length);
}

void format_scanner::report(std::string &rs)
{
	strprintf(rs, "format: %lu Hz, %u ch", fmt->rate, fmt->channels);
}
