#ifndef DMD_H_SCAN_POWER
#define DMD_H_SCAN_POWER
/*
	scan_power: Scanner that computes the loudness via RMS amplitude, like the normalize tool.

	I took the algorithm as described by Chris Vaill <chrisvaill@gmail> on http://normalize.nongnu.org/README.html
	and embodied in his normalize tool, which I used for quite some time already.
	This should give a better measure of loudness than the peak, although it can still be tweaked.
	As Chris notes himself, there is no frequency vs. human ear business, and the smoothing could be different.

	part of DerMixD
	(c)2008-9 Thomas Orgis, licensed under GPLv2
*/

#include "audio/scanner.hxx"

// Default same operation as normalize-0.7.7:
// Compute mean square amplitude in 100 chunks per second,
// then smooth these 100 values together for one value per second.
// Maximum (root of) square over all seconds is what we want.
// The smoothing currently is just linear mean again (as in normalize),
// so effectively we compute the maximum RMS per second.
#define CHUNKS_PER_SEC 100
#define CHUNKS_PER_WINDOW 100

// A window of chunk mean powers for one channel.
class power_window
{
	public:
	double sum;     // Running sum of sample power.
	unsigned int summed; // Number of summed samples.
	double power[CHUNKS_PER_WINDOW];
	unsigned int fill;
	unsigned int size;
	power_window(): sum(0), summed(0), fill(0), size(CHUNKS_PER_WINDOW) {};
	~power_window() {};
	double smooth(); // Compute smooth value, reset counters and values.
	bool add(); // Add mean of current chunk to power[], reset sum. Return if window is full.
};

class power_scanner: public scanner
{
	private:
	double maxpow;
	unsigned int channels; // Be safe: remember and use the number of channels from beginning (index for win!).
	power_window *win;  // Array of windows for the channels.
	unsigned long chunksize; // frames per chunk
	bool good; // Will be false if something funny happened (changed channels, p.ex.).

	public:
	power_scanner(audio_format *af);
	~power_scanner();
	void scan(mixer_buffer &sb);
	void report(std::string &rs);
};

#endif
