#ifndef DMD_H_FIFO_BUFFER
#define DMD_H_FIFO_BUFFER

/*
	fifo_buffer: audio data FIFO buffer, as such

	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2

	This is an attempt to separate the FIFO logic from the thread communication and input_file reading stuff in the audio_fifo class.
*/

#include "audio/audio_buffer.hxx"

// Let's add a specialized buffer for FIFO access (the whole logic of read/write positions and blocks).
// The audio_fifo does the locking around this one.
// Hm, this buffer should also do the zeroscanning...
// Another hint: This could also be turned into a template class, abstracting the audio type as usual.
class fifo_buffer: public audio_buffer
{
	private:
	void front_zeroscan(const audio_io_type level, const size_t range);
	void back_zeroscan( const audio_io_type level, const size_t range);
	// Advance given index by given amount and wrap around.
	void advance(size_t &index, const size_t offset);
	size_t advanced(const size_t index, const size_t offset);

	public:
	off_t position;
	bool got_end; // If we have the end in buffer (so can scan the back side).
	bool zeroscan; // Switch to enable zeroscan.
	size_t zero_range; // Range to do scan over.
	audio_io_type zero_level; // Level that still counts as zero.
	size_t readpos;
	size_t frontskip, backskip;
	bool front_scanned, back_scanned;
	fifo_buffer();
	fifo_buffer(int c, size_t s);
	~fifo_buffer();
	// Take desired values for zero scanning parameters and apply something that makes sense (make zerorange smaller, for example).
	void set_zero(bool enable, audio_io_type level, size_t range);
	// Get a normal (const-casted) pointer to write to and the maximum number of samples we could write.
	// Returns false if no space left to write to.
	bool get_writeblock(audio_io_type* &point, size_t &free_samples);
	// Tell the buffer that we have written that many samples.
	// This updates fill and does zeroscan work.
	void written(const size_t samples);
	// Extract samplecount samples into target buffer.
	// The actually extracted sample count is returned.
	size_t extract(audio_io_type *buf, size_t samplecount);
	// How many samples are waiting for extraction.
	// This excludes samples that are possibly needed for zeroscan.
	size_t available(void);
	// We can expect more samples to become available (we did not reach end yet, free space left).
	bool expect_more(void){ return (!got_end && fill < size); };
	// Call that to tell that you know there is nothing more.
	void end_reached(){ got_end = true; }
	// Same as above but without copying the data.
	size_t skip(size_t &wanted_samples);
	void reset(void); // Reset everything that is dynamic state.
	void discard(void); // Discard current contents, also end zeroscan result.
};

#endif
