#ifndef DMD_H_TIMEPITCH
#define DMD_H_TIMEPITCH

/*
	timepitch: time stretching effect

	part of DerMixD
	(c)2010-2011 Thomas Orgis, licensed under GPLv2

	This is the first effect that has input_samples != output_samples; plus the issue of not exactly knowing in advance how many samples one will need as input for a given output sample count.
*/

#include "audio/effect.hxx"

namespace dmd
{
namespace effect
{

class timepitch: public effect
{
	public:
	 timepitch();
	~timepitch();
	bool do_receive(mixer_buffer &buf, size_t wanted_samples);
	bool do_reset();

	private:
	class my_private;
	my_private *parts;
	mixer_buffer feed;
	bool flushed;

	void read_settings();
	bool write_settings();
};

}
}

#endif
