#ifndef DMD_H_LADSPA
#define DMD_H_LADSPA

/*
	ladspa: audio effect using LADSPA modules

	part of DerMixD
	(c)2011 Thomas Orgis, licensed under GPLv2
*/

#include "audio/effect.hxx"

namespace dmd
{
namespace effect
{

class ladspa: public effect
{
	public:
	ladspa(); // Generic construction for inquiries.
	~ladspa();
	void list_libs(std::vector<std::string*> &libs);
	// The library are to be named without path and suffix.
	// /usr/lib/ladspa/blafu.so -> blafu
	// DerMixD will always look in the LADSPA search paths, and only there.
	// Also note: This will un-load any currently loaded plugin!
	bool list_plugins(const std::string lib, std::vector<std::string*> &plugins);
	// Specific info about a single plugin is obtained via loading it and calling info().
	// The fullname is supposed to be something like ladspa:cmt:wshape_sine .
	// It is just used for outside convenience (applied to parameter info).
	bool load(const std::string lib, const std::string plugin, const std::string fullname="");
	void info(std::vector<std::string*> lines);
	bool do_reset();
	bool do_receive(mixer_buffer &buf, size_t wanted_samples);

	private:
	class my_private;
	my_private *parts;
	size_t bufsize; // Let's fix that ... got so many buffers related hanging around... still.
	bool load_lib(const std::string lib);
	void get_ports();
};

// Call once in single thread mode to settle search paths.
void ladspa_init();

}
}
#endif
