/*
	audio_io: most generic properties if input/output audio thingies

	part of DerMixD
	(c)2010-2013 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "audio/audio_io.hxx"
#include "mathhelp.hxx"
#include "debug.hxx"

namespace audio
{

// #warning "THIS conversion should be a method of the buffer ... not the io thing."
void iothing::append_to_mixer(audio_buffer &in, mixer_buffer &out)
{
	size_t addsamples = 0;
	audio::encode_from(format.encoding, in.ptr, in.my_current_size(), out.free_ptr(),  format.channels, addsamples);
	out.fill += addsamples;
}

void iothing::convert_to_io(mixer_buffer &in, audio_buffer &out)
{
	size_t bytes;
	audio::encode_to(format.encoding, in.ptr, in.channels, in.fill, out.ptr, bytes);
	// This should be the same as input samples!
	out.fill = format.bytes2samples(bytes);
}

bool source::plain_read(audio_io_type* point, size_t wanted_samples, size_t &got_samples)
{
	size_t fill = 0;
	size_t really_want = format.samples2bytes(wanted_samples);
	if(really_want == 0) return true;

	bool ret = do_read(point, really_want, fill);
	got_samples = format.bytes2samples(fill);
	position += got_samples;
	return ret;
}

bool source::buf_read(audio_buffer &abuf, size_t wanted_samples)
{
	size_t fill = 0;
	bool ret = plain_read(abuf.free_ptr(), min(abuf.free_space(), wanted_samples), fill);
	abuf.fill += fill;
	return ret;
}

bool source::mixbuf_read(mixer_buffer &abuf, size_t wanted_samples)
{
	size_t really_want = min(abuf.free_space(), wanted_samples);
	if(really_want == 0) return true;

	if(abuf.channels != format.channels || abuf.ptr == NULL) return false;

	// Now, assure that the device buffer is big enough, then read into it.
	// Actual reallocation will only happen if the size changed.
	if(iobuffer.reallocate(format.channels, really_want) != really_want)
	{
		MERROR("[source %p] unable to resize inbuffer!", this);
		return false;
	}

	iobuffer.fill = 0;
	bool ret = buf_read(iobuffer, really_want);
	if(ret) append_to_mixer(iobuffer, abuf);

	return ret;
}


bool sink::buf_write(audio_buffer &abuf)
{
	//if(abuf.channels != format.channels || abuf.ptr == NULL) return false;
	// Just increment the position... the value is invalid on error.
	position += abuf.fill;
	return do_write(abuf.ptr, abuf.my_current_size());
}

}
