#ifndef DMD_H_ACTIONLIST
#define DMD_H_ACTIONLIST

/*
	actionlist: A list of actions, with embedded exclusive locking.

	part of DerMixD
	(c)2009-2013 Thomas Orgis, licensed under GPLv2

	This is mainly needed for pusing actions from the socketeers to the main mixer thread. In other places, a simple vector of actions might be enough.
	The abstraction is rather thin, with the mutex not being hidden so that consumers can still lock the whole thing for iterating over the list. Main benefit is to have the mutex and the list of actions associated with each other.

	Note: This reeks of another action_queue ... just that it is geared
	towards bulk retrieval.
*/

#include "action.hxx"

#include <mutex.hxx>
#include "threads/semaphore.hxx"
#include <vector>

namespace dmd
{

class actionlist
{
	public:

	 actionlist() {};
	~actionlist() {};
	void pushing()
	{
		lock.lock();
	};
	void done_pushing()
	{
		sem.post();
		lock.unlock();
	};
	// Push one or two (or none) actions.
	// If you wonder: Socketeer needs to push one or two actions, that's what's needed.
	void push(action *act1, action *act2 = NULL)
	{
		pushing();
		if(act1 != NULL) list.push_back(act1);
		if(act2 != NULL) list.push_back(act2);
		done_pushing();
	};
	void push_some(std::vector<action*> &some)
	{
		if(!some.size()) return;
		pushing();
		list.insert(list.end(), some.begin(), some.end());
		done_pushing();
	};
	void pulling()
	{
		lock.lock();
	};
	void done_pulling()
	{
		list.clear();
		sem.zero();
		lock.unlock();
	};
	// Just tell if there is some action.
	// Non-blocking!
	bool got_work()
	{
		return sem.trywait();
	};
	// Wait for work to appear.
	void idle()
	{
		sem.wait();
		sem.post();
	};
	// A wrapper to have a handle on things, could take precautions,
	// add debugging, whatever.
	// Funny how I am rationalizing the introduction of an accessor.
	// This is supposed to be called while pulling(), perhaps I could wrap it up that way.
	std::vector<action*>& get_list()
	{
		return list;
	};

	private:
	real_mutex lock;
	semaphore sem; // For waking up the action consumer.
	std::vector<action*> list;
};

}


#endif
