#ifndef DMD_H_ACTION_QUEUE
#define DMD_H_ACTION_QUEUE
/*
	action_queue: workqueue for some worker thread

	part of DerMixD
	(c)2007-9 Thomas Orgis, licensed under GPLv2

	Well, you push action items into the queue at one end, and the worker at the other end pulls them.
	This class also can be (ab)used as a generic mutex, as long as you are not stupidly deadlocking youself with push/pull.
*/

#include "action.hxx"
#include "mutex.hxx"
#include "threads/semaphore.hxx"
#include <vector>
#include <queue>

namespace dmd {

class thread;

class action_queue: public real_mutex
{
	private:
	// A volatile queue gives a nice bulk of C++ blurp from g++ ... guess it's not needed or possible, then...
	// Also volatile actions don't work as this blows up the contained containers.
	// What's the deal with STL and volatile for threading?
	std::queue<action*> q;
	semaphore sem;

	public:
	size_t fill;
	action_queue();
	~action_queue();
	void    push(action *act);
	// Pull, enable cancellation for specified thread while waiting.
	action* pull(dmd::thread *cancelee = NULL);
};

}
#endif
