/*
	action_queue: workqueue for some worker thread

	part of DerMixD
	(c)2007-9 Thomas Orgis, licensed under GPLv2
*/
#include "basics.hxx"
#include "action_queue.hxx"
#include "debug.hxx"

namespace dmd {

action_queue::action_queue(): fill(0) { CONSTRUCT("action_queue"); }

action_queue::~action_queue()
{
	DESTBEGIN("action_queue");
	/* If there are still actions left, delete them. */
	if(fill > 0)
	{
		// Nobody should work on the action list any more... so the lock is strictly superfluous.
		// And, if somebody _would_ still try to push while destructing... well, that wouldn't be good in any case.
		lock();
		while(!q.empty())
		{
			delete q.front();
			q.pop();
		}
		unlock();
	}
	DESTEND("action_queue");
}

void action_queue::push(action *act)
{
	lock();
	MDEBUG("[action_queue %p] pushing %i", this, act->def->id);
	q.push(act);
	++fill;
	sem.post();
	unlock();
}

action* action_queue::pull(thread *cancelee)
{
	action* ret;
	if(!sem.wait(cancelee))
	{
		SERROR("Ugh! Unable to wait for a semaphore!");
		return NULL;
	}
	// Now, after waiting, get the first item.
	lock();
	if(fill < 1) ret = NULL;
	else
	{
		MXDEBUG("poppin' work from list with size %zu", q.size());
		ret = q.front();
		q.pop();
		--fill;
		MXDEBUG("poppin' work done from list with size %zu", q.size());
	}
	unlock();
	return ret;
}

}
