#!/usr/bin/perl

use lib "frontend";

use Param;

my $p = Param::Parse({"info", "I'm removing that C99-style variadic marcos from dermixd source code that are not _officially_ C++ ... I work directly on the files you give me!"},
[
	 "header", "debug.hxx", "H", "the debug header that should be un-included"
	,"macros", "sdebug,debug,debug_construct,debug_destruct,construct,destruct,destbegin,destend,xdebug,sxdebug", "m", "the offending macros..."
	,"replace-macros", "error,serror", "M", "macros to generate a replacement for"
]);

my $headermatch = '#include\s+"'.$p->{header}.'"';
$p->{macros} =~ s/,+/|/g;
$p->{'replace-macros'} =~ s/,+/|/g;
my $macromatch = '('.$p->{macros}.')\(';
my $rmacromatch = '('.$p->{'replace-macros'}.')\(';

foreach my $file (@ARGV)
{
	print "working on $file\n";
	open(FI, $file) or die "cannot read $file!\n";
	my @inh = <FI>;
	open(FI, ">$file") or die "cannot write to $file!\n";
	my $line = 0;
	for(@inh)
	{
		++$line;
		s@^(\s*)($headermatch)@$1// $2@;
		s@^(\s*)(|else\s+)($macromatch)@$1;// $2$3@;
		s@^(\s*if\s*\(.+\)\s+|\s*|\s*else\s+)($rmacromatch)[^;]+;@$1fprintf(stderr, "some error at $file:$line\\n");@;
		print FI;
	}
	close(FI);
}
