#!/usr/bin/perl

use File::Basename;

my $log  = 'test.log';
my $good = 'PASS';
my $bad  = 'FAIL';

open(LOG, ">$log") or die "Cannot open log file $log! ($!)\n";

print <<EOT;
Starting tests, look into test.log for messages.
$good is good, $bad is bad.

EOT
print LOG "Beginning tests.\n";

my $fail = 0;

my $proglen = 0;
foreach my $prog (@ARGV)
{
	my $base = basename($prog);
	$proglen = length($base) if length($base) > $proglen;
}

foreach my $prog (@ARGV)
{
	my $base = basename($prog);
	my $command = $prog;
	my $script = "tests/$base.sh";
	print STDOUT "$base: ";
	if(-f $script)
	{
		$command = "sh $script $prog";
	}
	print LOG "\nTEST: Output of $command:\n";

	my $locfail = -1;
	if(open(PROG, "$command 2>>$log |"))
	{
		while(<PROG>)
		{
			$locfail = 1 if /$bad/o;
			$locfail = 0 if /$good/o;
		}
		close(PROG);
	}
	$fail = 1 if $locfail;
	print ' ' x ($proglen-length($base)), ($locfail ? $bad : $good), ($locfail < 0 ? ' (execute FAIL)' : ''), "\n";
}

print STDOUT "\n", $fail ? "FAIL" : "PASS", "\n";

close LOG;

exit $fail;
