#!/usr/bin/perl

# reads from stdin the log output (stderr) of dermixd compiled with -DMEMDEBUG and matches the object constructions against finished destructions
# printing out a list of objects that have not been destructed

my %stat;

while(<STDIN>)
{
	if(/^_(C|D|F) ((\S+) ?(.*))$/)
	{
		if($1 eq 'C')
		{
			$stat{$2} = 'constructed';
		}
		elsif($1 eq 'D')
		{
			$stat{$2} = 'destructing';
		}
		else
		{
			defined (delete $stat{$2}) or die "non-existing object deleted ($2)???\n";
		}
	}
}

for(keys %stat)
{
	print "still there: $_ ($stat{$_})\n";
}
