#!/usr/bin/perl

use File::Basename;

my $src_prefix = 'src/';
my $bin_prefix = 'bin/';

my $verb = 0; # verbose blabbering

# Get dependencies for C/C++ source.

my $depprefix = shift(@ARGV);
my $file = shift(@ARGV);
my $depfile = $depprefix.$file;
my @blacklist = split(/\s+/, shift(@ARGV));
my @extradep = split(/\s+/, shift(@ARGV)); # all objects depend on these as extra sources
die "need some file to work on!\n" unless(defined $file);

sub on_blacklist
{
	my $file = shift;
	$file =~ s/\.[^\.]+$//; # strip ending
	return (grep {$_ eq $file} @blacklist) ? 1 : 0;
}

my $is_optional = on_blacklist($file);

# Fill the include directory list.
my @dirs = @ARGV;
my @src, @obj, @objsrc;
my $has_main = filedeps($file, \@dirs, \@src, \@obj, \@objsrc);

# Both object and dep file depend on main source and all headers.
push(@src, @extradep);
print $obj[0]." $depfile: @src\n";
# Object needs to be cleaned up.
print "cleanfiles += $obj[0]\n";

if($has_main)
{
	# The dependency file depends on the dependencies of the direct dependendees.
	print "$depfile:";
	foreach my $oj (@objsrc)
	{
		print " $depprefix$oj";
	}
	print "\n";

	# Now recurse to find all objects needed for linking.
	# Cannot offload that work to 'make' ... or can I?
	while(defined (my $s = shift @objsrc))
	{
		filedeps($s, \@dirs, \@src, \@obj, \@objsrc);
	}
	# The binary needs a list of _all_ objects.
	# So, depfile needs to depend on all sources that play a role.
	$bin = $file;
	$bin =~ s:\.([cC]([pP]{0,2}|[xX]{0,2}))$::;
	$bin =~ s:^$src_prefix::;
	print "$bin_prefix$bin: @obj\n";
	print "cleanfiles += $bin_prefix$bin\n";
}

sub push_unique
{
	my $arr = shift;
	foreach my $val (@_)
	{
		push(@{$arr}, $val) unless grep { $_ eq $val } @{$arr}; 
	}
	return $#{$arr}+1;
}

sub filedeps
{
	my $file = shift;
	print STDERR "filedeps: $file\n" if $verb;
	my $dirs = shift;
	my $sources = shift;
	my $objects = shift;
	my $objsource = shift;
	my @history = ();
	my @dirs = (dirname($file), @{$dirs});
	return 0 unless -f "$file";
	my $has_main = 0;
	my $first = 1;
	if($file =~ /^(.*)\.([cC]([pP]{0,2}|[xX]{0,2}))$/)
	{
		push_unique($objects, "$1.o");
		my @deps = ($file);
		my $end = $2;
		my $count = 0;
		do
		{
			my $dfile = shift(@deps);
			push(@{$sources}, $dfile);

			my $lineno = 0;
			if(open(DAT, $dfile))
			{
				while(<DAT>)
				{
					++$lineno;
					my $line = $_;
					# Watch out for main()... be reasonable; when user writes obscure code he gets obscure results.
					# But only look in the primary file!
					$has_main = 1 if($first and $line =~ /^\s*int\s+main\s*\(.*\)/);
					#should match all header names...
					if($line =~ /^\s*\#\s*include\s+\"(.+\.[ihH].{0,2})\"/)
					{
						my $header = $src_prefix.$1;
						unless(-f $header)
						{
							if(-f (my $nh = dirname($file).'/'.$header))
							{
								$header = $nh;
							}
							else
							{
								foreach my $d (@dirs)
								{
									if(-f (my $nh = $d.'/'.$header))
									{
										$header = $nh; last;
									}
								}
							}
						}
						$header =~ s,//,/,g;
						die "Where is $header ($dfile:$lineno)?\n" unless -f $header;
						# Only push new headers, also only non-optional ones unless we are working on an optional file.
						unless((not $is_optional and on_blacklist($header)) or grep { $_ eq $header } (@{$sources},@deps))
						{
							print STDERR "header: $header\n" if $verb;
							push_unique(\@deps, $header);
							my $base = $header;
							$base =~ s/\.[ihH].{0,2}$//;
							my $source = $base.'.'.$end;
							if(-f $source)
							{ # There is an object to be expected.
								print STDERR "object: $base.o\n" if $verb;
								push_unique($objects, $base.'.o');
								push_unique($objsource, $source); # for linking...
							}
						}
					}
				}
				close(DAT);
				$first = 0;
			}
		}
		while(@deps and ++$count < 1000); #1000 dep iterations should be enough!
		if($count == 1000){ print STDERR "You sure that you didn't do sth. circular?\n"; }
	}
	return $has_main;
}
