#ifndef DMD_H_WAITER_GROUP
#define DMD_H_WAITER_GROUP
/*
	waiter_group: A group of threads waiting for something.

	part of DerMixD
	(c)2004-7 Thomas Orgis, licensed under GPLv2
*/

#include <pthread.h>
#include "common.hxx"
#include "comm_data.hxx"

typedef struct commsemal
{
	comm_data* cd;
	unsigned char type;
} commsemal;

class waiter_group
{
private:
	vector<commsemal> cs;
	pthread_mutex_t cs_lock;

public:
	 waiter_group();
	~waiter_group();
	void add(comm_data* commdat, unsigned char type);
	void clear();
	/* End waiting for the first waiter that matches given type, setting error and return values.
	   Type 0 is special for any type (whole group). */
	bool finalize(unsigned char type, unsigned char errcode, double retval, unsigned long int retval_ulong);
	bool finalize(unsigned char type, unsigned char errcode); /* Return values default to 0. */
	void finalize(unsigned char errcode); /* End waiting for whole group with common error code. */
	static const unsigned char anyone = 0;
	static const unsigned char end_error = 255; /* Waiting ended because of end of existence of group (destructor). */
};

// Same stuff, without the common context.
bool finalize_single_waiter(comm_data* cd, unsigned char errcode, double retval, unsigned long int retval_ulong);

#endif
