/*
	waiter_group: A group of threads waiting for something.

	part of DerMixD
	(c)2004-7 Thomas Orgis, licensed under GPLv2
*/

#include "waiter_group.hxx"

waiter_group::waiter_group(){ pthread_mutex_init(&cs_lock, NULL); }
waiter_group::~waiter_group()
{
	finalize(end_error);
	pthread_mutex_destroy(&cs_lock);
}

void waiter_group::clear()
{
	cs.clear();
}

void waiter_group::add(comm_data* commdat, unsigned char type)
{
	commsemal tempcs;
	pthread_mutex_lock(&cs_lock);
	tempcs.cd = commdat;
	tempcs.type = type;
	cs.push_back(tempcs);
	pthread_mutex_unlock(&cs_lock);
}

void waiter_group::finalize(unsigned char errcode)
{
	finalize(anyone, errcode);
}

bool waiter_group::finalize(unsigned char type, unsigned char errcode)
{
	return finalize(type, errcode, 0, 0);
}

bool waiter_group::finalize(unsigned char type, unsigned char errcode, double retval, unsigned long int retval_ulong)
{
	pthread_mutex_lock(&cs_lock);
	if(cs.size() > 0)
	{
		for(vector<commsemal>::iterator i = cs.begin(); i != cs.end(); ++i)
		{
			if( (type == anyone) || ((*i).type == type) )
			{
				(*i).cd->errcode = errcode;
				(*i).cd->retval = retval;
				(*i).cd->retval_ulong = retval_ulong;
				sem_post((*i).cd->waitress);
				if(type != anyone)
				{
					cs.erase(i);
					pthread_mutex_unlock(&cs_lock);
					return true; //found a waiter
				}
			}
		}
		if(type == anyone)
		{
			cs.clear();
			pthread_mutex_unlock(&cs_lock);
			return true; //anything found
		}
	}
	pthread_mutex_unlock(&cs_lock);
	return false; //not found
}

bool finalize_single_waiter(comm_data* cd, unsigned char errcode, double retval, unsigned long int retval_ulong)
{
	if(cd != NULL)
	{
		cd->errcode = errcode;
		cd->retval = retval;
		cd->retval_ulong = retval_ulong;
		sem_post(cd->waitress);
		return true; //did it
	}
	else return false; //nothing to do
}
