#ifndef DMD_H_IN_MPG123
#define DMD_H_IN_MPG123

/*
	in_mpg123: mpg123 input device; the initial reason for DerMixD to exist at all
	
	part of DerMixD
	(c)2004-7 Thomas Orgis, licensed under GPLv2
*/

#include "common.hxx"
#include "action_queue.hxx"
#include "waiter_group.hxx"
#include "audio_fifo.hxx"
#include "input.hxx"

class mpg123_file: public input_file
{
private:
	comm_data cd; // Access to this object is non-parallel, so we can share this,
	vector<double> eq_val; // Upcoming equalizer values.
	void check_eq();
	void let_me_die(unsigned char code, const string reason);
	bool pause();
	bool load(input_data *data);

public:
	volatile bool decoder_paused;
	volatile bool decoder_stopped;
	volatile bool new_pos;
	volatile bool eq_pending;
	volatile bool new_eq;
	volatile bool im_ready; //decoder there?
	volatile bool on_line;
	waiter_group waiters;
	int audio_fd;
	FILE* status;
	FILE* control;
	audio_fifo* prebuffer;
	//sem_t* playsem;
	bool zeroscan;

	 mpg123_file();
	~mpg123_file();
	bool do_read(audio_buffer *buffer, unsigned int wanted_samples);
	bool do_open(input_data *data);
	void do_close(){};
	bool do_seek(input_data *data){ return false; }; // Needs call with position.
	bool do_seek(input_data *data, unsigned long pos);
	bool do_length(input_data *data);
	bool do_eq(const vector<double> &val);
};

//data for mpg123 watching thread
class backdata: public thread_data
{
	public:
	mpg123_file *mf;
	input_data* data;
	string msg;
};

/* Wrapper over mpg123_file with the added backwatch/listener thread for decoder responses. */
class mpg123_input: public input_device
{
	protected:
		unsigned int decoder_pid;
		pthread_t listener;
		bool listener_there;
		backdata bd;
		mpg123_file mf;

	public:
		static const string t;
		mpg123_input(input_data* chd);
		~mpg123_input();
		bool online(){ return mf.on_line && mf.prebuffer->readstate != -1; };
};

#endif
