#ifndef DMD_H_AUDIO_FIFO
#define DMD_H_AUDIO_FIFO

/*
	audio_fifo: audio data FIFO buffer on a file (pipe)
	
	part of DerMixD
	(c)2004-8 Thomas Orgis, licensed under GPLv2
	
	This one handles in a not very appealingly nice coded but working way the (re)filling of an audio buffer from a file (pipe) and copying from this buffer including wrapping to qualify as a FIFO buffer.
	
	The constructor takes two strange arguments: two pointers to booleans (stored in endboolA and endboolB).
	These are needed because we deal with several audio tracks coming through one file (pipe) and it is impossible to know if a track ended (the file normally doesn't end) from the data alone or from the availability of data (at least not reliably). Thus, the pipe reading procedure watches these two booleans (either one becoming true) to end the current reading attempt when no data is there.
*/

#include "audio_buffer.hxx"
#include "thread_container.hxx"

class audio_fifo: public audio_buffer, public thread_data
{
	private:
		audio_buffer skipper; // Fake buffer for skipping.

	public:

		volatile bool* endboolA;
		volatile bool* endboolB;
		int fd; //file descriptor to read from
		volatile unsigned int readerpos; //position in buffer
		volatile unsigned int skipped; //skipped samples at beginning, offset to position
		volatile bool zeroscan;
		volatile bool front_scanned; // if we have scanned the front for zeroes
		//possible source of trouble when audio_type changes!
		volatile int zero_level; // absolute sample value considered maximum zero
		volatile unsigned int zero_range; //range of samples to do zeroscan over
		pthread_t rthread;
		sem_t rsem; // for activating reader thread
		sem_t wsem; // for indicating waiting status
		bool sem_there, reader_there;
		volatile bool reader_pause;
		volatile unsigned int aimed_fill; // fill we want, not more atm
		volatile int readstate;
		bool active;
		int wait_usec;

		//constructor parameters:
		//file descriptor, channel count, size in samples, bool signalling upcoming end, another one
		audio_fifo(int file, unsigned int c, unsigned int s, volatile bool* ebA, volatile bool* ebB);
		~audio_fifo();
		volatile bool got_end; //true when we reached a track end in the file
		//copy wanted_samples into target
		bool gimme(audio_buffer& target, unsigned int& wanted_samples);
		// skip a number of samples, return difference of actually skipped to requested
		unsigned int skip(const unsigned int skip_samples);
		// read up everything till end, return count of samples drained
		unsigned long drain();
		// tell if reading thread is waiting
		bool waiting();
		// start and stop reading thread
		void start();
		void stop();
		//omit zeroes at beginning (via advancement of position)
		void frontzeroscan();
		//omit zeroes at end (via reduction of size)
		void backzeroscan();
		void fresh(); // reinit zeroscan stuff (new track coming)
		unsigned int get_zeroskip(); // get the skipped samples at front
		//resize internal buffer, with and without changing channel count
		unsigned int resize(unsigned int s);
		unsigned int resize(unsigned int c, unsigned int s);
		//empty buffer
		void clear();
		//give status on cerr... may vanish in future when I really believe in the code
		void status();
		void set_zero(int zero, unsigned int range);
};

#endif
