#part of ThOrMA
#DerMixD/Fader.pm: interface to DerMixD using two channels with some fading.

#Copyright (c) 2003-8 Thomas Orgis (thomas@orgis.org)
#This is Open Source, Distribution and Modification under the terms of the Artistic License
#see the file LICENSE in the package root

package DerMixD::Fader;

use strict;
#use Time::HiRes qw(sleep);
use DerMixD::Base;

our @ISA = qw(DerMixD::Base);

our %default =
(
	 't_overlap', 5
	,'t_out',     3.5
	,'t_in',      2
	,'v_a',       0
	,'v_e',       0
	,'t_step',    0.1
);

# Plain function, call as DerMixD::Fader::params().
sub params
{
	my $ar = shift;
	my @l = 
	(
		 't_overlap', $default{t_overlap}, '','XFade: default time to overlap adjacent tracks in seconds'
		,'t_out',     $default{t_out},     '','XFade: default duration of fade-out in seconds'
		,'t_in',      $default{t_in},      '','default duration of fade-in in seconds'
		,'v_a',       $default{v_a},       '','starting volume for fade-in (0...1)'
		,'v_e',       $default{v_e},       '','ending volume for fade-out (0...1)'
		,'t_step',    $default{t_step},    '','Step interval length at XFade, unless you really know why you probably shouldnt play with it, but your PC wont explode when you do (no promise;-)'
	);
	if(defined $ar)
	{
		DerMixD::Base::params($ar);
		push(@{$ar}, @l);
	}
	else
	{
		return DerMixD::Base::params(), @l;
	}
}

sub new
{
	my $class = shift;
	# The Base constructor also gets the connection up.
	my $self = DerMixD::Base->new(@_);
	my $config = shift;
	$self->{Defaults} = {};
	for(keys %default)
	{
		$self->{Defaults}{$_} = defined $config->{$_} ? $config->{$_} : $default{$_};
	}
	bless $self, $class;
	$self->FadeSet();
	return $self;
}

#i use exponential curves...
#knowing that i'll rarely will get more than 200 real steps i'l say that
#my exp-curves are quite equal 0/1 at a diff of 1/200 (0.005),
#so the grounding interval is... lets be generous...  [0:5]

sub Curve #(steps)
{
#	my $self = shift;
	my @l = ();
	my $steps = $_[0];
	if($steps < 1){return @l;} #sth isnt ok here
	my $stlen = 5/$steps;
#	print "#Curve with $steps steps:\n";
	for(my $i = 0;$i < $steps; ++$i) #0...steps+1
	{
		$l[$i] = exp(-$i*$stlen);
#		print $i,"\t",$l[$i],"\n";
	}
	$l[$steps] = 0;
#	print $steps,"\t",$l[$steps],"\n";
#	print "#Curve end.\n";
	return @l;
}

sub BassCurve #(steps)
{
#	my $self = shift;
	my @l = ();
	my $steps = $_[0];
	if($steps < 1){return @l;} #sth isnt ok here
	my $stlen = 5/$steps;
#	print "#Curve with $steps steps:\n";
	for(my $i = 0;$i <= $steps; ++$i) #0...steps+1
	{
		$l[$i] = exp(-0.25*$i*$stlen);
		
#		print $i,"\t",$l[$i],"\n";
	}
#	print $steps,"\t",$l[$steps],"\n";
#	print "#Curve end.\n";
	return @l;
}


sub Round #only positive
{
	my $self = shift;
	my $e = int($_[0]);
	if(($_[0] - $e) >= 0.5){++$e;}
	return $e;
}

sub script_nogap
{
	my $self = shift;
	my @ch;
	$ch[0] = shift;
	$ch[1] = shift;
	if(defined &MixPlayer::Log and $MixPlayer::debug){&MixPlayer::Log("NixFade: $ch[0] (".$self->{in}[$ch[0]]{vol}.") --)=- $ch[1] (".$self->{in}[$ch[1]]{vol}.")");}

	$self->Command(['delscript', $ch[0]]);
	$self->Command(['delscript', $ch[1]]);
	$self->Command(['follow',$ch[0],$ch[1]]);
	# Make sure we are not too late.
	$self->FullStatus();
	if($self->{in}[$ch[1]]{status} eq 'stopped' and $self->{in}[$ch[0]]{status} eq 'stopped')
	{
		# we were not successful here... perhaps the follow was too late and leader already ended before
		# start manually and clean up
		$self->Command(['start', $ch[1]]); #make sure
		$self->Command(['nofollow', $ch[0]]);
	}
}

# This is _not_ safe!
# I need to rework the mixplayer at all... it needs a proper design, also with respect to scripted fading.
sub script_xfade #(from,to,time offset)
{
	my $self = shift;
	#(from,to)
	my @ch = (shift, shift);
	my $timeoff = shift;
	my $skip = shift; # seconds to skip from second track
	$skip = 0 unless defined $skip;
	#computing start and end volumes
	my @start_vol = ();
	my @end_vol = ();
	$self->FullStatus();
	$timeoff = $self->{in}[$ch[0]]{position}+1 unless defined $timeoff;
	if($timeoff - $self->{in}[$ch[0]]{position} < 1)
	{
		print STDERR "Oh... I'm being late for fading! The method needs rework...\n";
		$self->script_nogap(@ch);
		return;
	}

	$start_vol[$ch[0]] = $self->{in}[$ch[0]]{vol};
	$end_vol[$ch[0]] = $self->Round($self->{v_e} * $self->{in}[$ch[0]]{vol});
	$end_vol[$ch[1]] = $self->{in}[$ch[1]]{vol};
	$start_vol[$ch[1]] = $self->Round($self->{v_a} * $self->{in}[$ch[1]]{vol});
	
	#difference to achieve during fade
	my @diff = ();
	$diff[$ch[0]] = $end_vol[$ch[0]] - $start_vol[$ch[0]];
	$diff[$ch[1]] = $end_vol[$ch[1]] - $start_vol[$ch[1]];

	#verbosity
	if(defined &MixPlayer::Log and $MixPlayer::debug)
  {
  	&MixPlayer::Log("XFade: $ch[0] ($start_vol[$ch[0]] -> $end_vol[$ch[0]]) ==> $ch[1] ($start_vol[$ch[1]] -> $end_vol[$ch[1]])");
		&MixPlayer::Log("XFade: over: $self->{oversteps} ($self->{t_overlap}s), in: $self->{insteps} ($self->{t_in}s), out: $self->{outsteps} ($self->{t_out}s)");
  }
	# Start playback of new track at given offset in old track.
	# Base any fade timing on the _new_ track!
	#start new track, start fadein ... after t_over-t_out fade out, done after t_over
	#so, t_over must be >= t_in and t_out, that's the rule
	$self->Command(['delscript', $ch[0]]);
	$self->Command(['delscript', $ch[1]]);
	$self->Command(['seek', $ch[1], $skip]); # make sure we are at correct offset
	$self->Command(['script', $ch[0], $timeoff, 'start', $ch[1]]);
	for(my $i = 0;$i < $self->{oversteps}; ++$i)
	{
		my $t = $skip+$i*$self->{t_step};
		if($i >= $self->{routsteps})
		{
			$self->Command(['script', $ch[1], $t, 'vol', $ch[0], $end_vol[$ch[0]] - $self->Round($diff[$ch[0]] * $self->{curve_out}->[$i-$self->{routsteps}])]);
		}
		if($i <= $self->{insteps})
		{
			$self->Command(['script', $ch[1], $t, 'vol', $ch[1], $end_vol[$ch[1]] - $self->Round($diff[$ch[1]] * $self->{curve_in}->[$i])]);
			$self->Command(['script', $ch[1], $t, 'eq',  $ch[0], $self->{basscurve}->[$i], 1, 1]);
		}
	}
	# Fix the end state: volumes, stopping of first channel.
	$self->Command(['script', $ch[1], $self->{t_overlap}, 'vol', $ch[0], $end_vol[$ch[0]]]);
	$self->Command(['script', $ch[1], $self->{t_overlap}, 'vol', $ch[1], $end_vol[$ch[1]]]);
	$self->Command(['script', $ch[1], $self->{t_overlap}, 'stop', $ch[0]);
}

sub FadeSet #([t_overlap[,t_out[,t_in[,v_a[,v_e]]]]])
{
	my $self = shift;
	if(($MixPlayer::debug) && (defined &MixPlayer::Log))
	{
		if(@_){&MixPlayer::Log("FadeSet: Got ".join(',',@_));}
		else{&MixPlayer::Log("FadeSet: Got nothing");}
	}
	$self->{t_overlap} = $self->{Defaults}->{t_overlap};
	$self->{t_out} = $self->{Defaults}->{t_out};
	$self->{t_in} = $self->{Defaults}->{t_in};
	$self->{v_a} = $self->{Defaults}->{v_a};
	$self->{v_e} = $self->{Defaults}->{v_e};
	if(defined $_[0])
	{
		$self->{t_overlap} = ($_[0] ne '-') ? $_[0] : $self->{t_overlap};
		if($#_ > 0)
		{
			$self->{t_out} = ($_[1] ne '-') ? $_[1] : $self->{t_out};
			if($#_ > 1)
			{
				$self->{t_in} = ($_[2] ne '-') ? $_[2] : $self->{t_in};
				if($#_ > 2)
				{
					$self->{v_a} = ($_[3] ne '-') ? $_[3] : $self->{v_a};
					if($#_ > 3)
					{
						$self->{v_e} = ($_[4] ne '-') ? $_[4] : $self->{v_e};
					}
				}
			}
		}
	}
	if(($MixPlayer::debug) && (defined &MixPlayer::Log)){&MixPlayer::Log("FadeSet: Made: $self->{t_overlap},$self->{t_out},$self->{t_in},$self->{v_a},$self->{v_e}");}
	if(($self->{Defaults}->{t_step}) && ($self->{t_overlap}))
	{
		$self->{oversteps} = int($self->{t_overlap} / $self->{Defaults}->{t_step});#integer steps ... recalculating t_steps accordingly
		$self->{t_step} = $self->{t_overlap} / $self->{oversteps};
		$self->{insteps} = int($self->{t_in} / $self->{t_overlap} * $self->{oversteps});
		$self->{outsteps} = int($self->{t_out} / $self->{t_overlap} * $self->{oversteps});
		if($self->{oversteps} < $self->{insteps}){$self->{oversteps} = $self->{insteps};} #be careful...
		if($self->{oversteps} < $self->{outsteps}){$self->{oversteps} = $self->{outsteps};}
		$self->{routsteps} = $self->{oversteps} - $self->{outsteps};
	}
	else
	{
		$self->{oversteps} = 0;
		$self->{t_step} = 0;
		$self->{outsteps} = 0;
		$self->{insteps} = 0;
		$self->{t_overlap} = 0;
		$self->{t_in} = 0;
		$self->{t_out} = 0;
		$self->{routsteps} = 0;
	}
	if(($MixPlayer::debug) && (defined &MixPlayer::Log)){
  &MixPlayer::Log("FadeSet_Steps: over: $self->{oversteps}, in: $self->{insteps}, out: $self->{outsteps}");
  }
	my @curve_in = &Curve($self->{insteps});
	my @curve_out = &Curve($self->{outsteps});
	my @basscurve = &BassCurve($self->{insteps});
	$self->{curve_in} = \@curve_in;
	$self->{curve_out} = \@curve_out;
	$self->{basscurve} = \@basscurve;
}


return 1;
