/*
	thread_container: Test for basic functionality of my threading stuff.

	part of DerMixD
	(c)2009 Thomas Orgis, licensed under GPLv2

	This program tries to start some threads and print out a list of them. Posts on a semaphore some times, then joins.

	Idea: I could check if thread priorities have influence by counting how many times a thread catches the semaphore. Not sure if I'd see something there.
*/

#include "basics.hxx"

#include "threads/threads.hxx"
#include "threads/semaphore.hxx"
#include "parsenum.hxx"
#include "tstring.hxx"
#include "shortcuts.hxx"

#include "debug.hxx"

using namespace std;

class testthread: public dmd::thread
{
	public:
	int win_count;
	int id;
	semaphore *insem, *outsem;

	testthread(int theid, semaphore &theinsem, semaphore &theoutsem, const string name = "some test thread", int pri_offset=0):
		 thread(name, pri_offset)
		,win_count(0), id(theid)
		,insem(&theinsem), outsem(&theoutsem)
	{};

	~testthread(){};

	void thread_work()
	{
		fprintf(stderr, "Thread %i: Startup.\n", id);
		outsem->post(); // Notify that we are ready.
		while(insem->wait(this)){ fprintf(stderr, "Thread %i: Got the sign.\n", id); ++win_count; }
		MERROR("Thread %i: Waiting on the semaphore failed?", id);
	};
};

int endthem(vector<testthread> &tlist)
{
	int bad = 0;
	FOR_VECTOR(testthread, tlist, i)
	{
		printf("Cancelling and joining a thread.\n");
		if(!i->thread_kill()) ++bad;
	}
	return bad;
}

int main(int argc, char** argv)
{
	int ret = 0;
	int npost = 100;
	if(argc >= 2) npost = str_to_int(argv[1]);

	semaphore sem, osem;
	dmd::thread_container prime;
	dmd::thread_container sub;
	prime.sub_thread_container = &sub;

	vector<testthread> threads;
	threads.push_back(testthread(1, sem, osem, "fred", 1));
	threads.push_back(testthread(2, sem, osem));
	threads.push_back(testthread(3, sem, osem, "lamer", 2));

	prime.create_thread(&(threads[0]));
	sub.create_thread(&(threads[1]));
	sub.create_thread(&(threads[2]));

	// Make sure the threads are working.
	for(size_t i=0; i<threads.size(); ++i)
	osem.wait();

	vector<string*> threadinfo;
	size_t count = prime.thread_info(threadinfo);
	if(count != threadinfo.size())
	{
		SERROR("Bad thread count!");
		ret = 100;
	}

	printf("Hosting %zu (%zu) threads:\n", count, threadinfo.size());

	for(vector<string*>::iterator i = threadinfo.begin(); i != threadinfo.end(); ++i)
	{
		printf("%s\n", (*i)->c_str());
		delete *i;
	}

	fprintf(stderr, "Master: Giving some signs.\n");
	for(int i=0; i<npost; ++i)
	sem.post();

	sleep(1);

	ret += endthem(threads);

	printf("Final statistics:\n");
	for(size_t i=0; i<threads.size(); ++i)
	printf("Thread %zu won %i times\n", i, threads[i].win_count);

	return ret;
}
