#include "basics.hxx"

#include "audio/audio_buffer.hxx"
#include "in/input_file.hxx"
#include "file_type.hxx"

#include <iostream>

using namespace std;

int main(int argc, char **argv)
{
	if(argc < 2)
	{
		cerr << "I want one file to read from, optionally a forced type beforehand." << endl;
		return -1;
	}

	int ret = 0;
	input_file *file = NULL;
	const char *name;
	enum input::type_id type = input::invalid;
	if(argc > 2)
	{
		type = input::name_to_id(argv[1]);
		name = argv[2];
		cerr << "You forced type " << input::id_to_name(type) << "(from " << argv[1] << ")" << endl;
	}
	else
	{
		name = argv[1];
		cerr << "Detecting type..." << endl;
		input::file_type typer;
		type = typer.guess(name);
		cerr << "Result: " << input::id_to_name(type) << endl;
	}

	if(input::switch_file(file, type))
	{
		if(!file->ready())
		{
			cerr << "File construction did not go well. Possible testament:" << file->err.text << "(" << (unsigned int)file->err.code << ")" << endl;
			ret = -5;
			goto end;
		}
		if(file->do_open_safe(name))
		{
			audio_buffer buf;
			buf.reallocate(file->format.channels, 2000);
			if(file->buf_read(buf))
			{
				buf.print_text(cout);
			}
			else
			{
				cerr << "Cannot read from file: " << file->err.text << "(" << (unsigned int)file->err.code << ")" << endl;
				ret = -4;
				goto end;
			}
		}
		else
		{
			cerr << "Cannot open file: " << file->err.text << "(" << (unsigned int)file->err.code << ")" << endl;
			ret = -3;
			goto end;
		}
	}
	else
	{
		cerr << "Failed to create a matching input_file instance, checking possible reasons..." << endl;
		if(type == input::invalid) cerr << "The type is invalid." << endl;
		else if(!input::type_available(type)) cerr << "The type is not built-in." << endl;

		ret = -2;
		goto end;
	}

end:
	if(file != NULL) delete file;

	return ret;
}
