// A test for looking at what the fullchansample function does.
// It produces an input signal of fixed sample count and transforms that according to given paramters.

#include "basics.hxx"
#include "audio/audio_buffer.hxx"

#include <cmath>

int main(int argc, char **argv)
{
	// show_fullchansample outcount inchan outchan vol0 vol1
	if(argc < 7)
	{
		fprintf(stderr, "Gimme: incount outcount inchan outchan vol0 vol1\n");
		return 2;
	}
	long count = atol(argv[1]);
	size_t incount = (count > 0) ? count : 1;
	count = atol(argv[2]);
	size_t outcount = (count > 0) ? count : 1;
	int inchan = atoi(argv[3]);
	if(inchan < 1) inchan = 1;
	if(inchan > 2) inchan = 2;
	int outchan = atoi(argv[4]);
	if(outchan < 1) outchan = 1;
	if(outchan > 2) outchan = 2;
	float vol[2];
	vol[0] = atof(argv[5]);
	vol[1] = atof(argv[6]);

	mixer_buffer in, out;
	in.reallocate(inchan, incount);
	out.reallocate(outchan, outcount);

	// Fill input with a sine function that has 10 periods.
	if(in.channels == 1)
	{
		for(size_t i=0; i<in.size; ++i)
		{
			in.ptr[i] = std::sin(2.0*3.14159265358979323846 * 10 * (double)i/(in.size-1));
		}
	}
	else // 2 channels... do the channels with phase shift of pi so that they cancel when mixed
	{
		for(size_t i=0; i<in.size; ++i)
		{
			in.ptr[2*i] = std::sin(2.0*3.14159265358979323846 * 10 * (double)i/(in.size-1));
			in.ptr[2*i+1] = - in.ptr[2*i];
		}
	}
	in.fill = in.size;

	// It's periodic ... we start at zero.. let's assume start values are zero.
	audio_type startval[2];
	startval[0] = startval[1] = 0;
	out.chesamplify(in, out.size, vol, startval);
	if(out.fill != out.size)
	{
		fprintf(stderr, "The conversampler didn't produce as many samples as desired.");
		return 1;
	}
	printf("# resampled 10-period sine, ch %i to %i, from %zu to %zu\n", in.channels, out.channels, in.size, out.fill);
	out.printout();
	return 0;
}
