// A test program that just shows what clipping does to floating point samples.
// It's a ramp from -10 to 10 ... which should be clipped to -1:1 hard or soft.

#include "basics.hxx"
#include "audio/audio_format.hxx"

int main(int argc, char **argv)
{
	const size_t count = 1000;
	const float start = -10;
	const float end   =  10;
	const float step  = (end-start)/(count-1);
	float inbuf[count], outbuf[count];
	audio_type mixbuf[count];
	size_t samples, bytes;
	int16_t s16out[count];
	int32_t s32out[count];

	if(argc < 2)
	{
		fprintf(stderr, "Gimme the clip width.\n");
		return 1;
	}

	float clip_width = atof(argv[1]);

	audio::clip_init(clip_width);

	// Fill with values...
	for(size_t i=0; i<count; ++i)
	inbuf[i] = i*step + start;

	// Encode from/to the same type, yielding clipping as the only effect.
	audio::encode_from(audio::float_32, inbuf, count*sizeof(float), mixbuf, 2, samples);
	fprintf(stderr, "Assuming 2 channels, I got %zu.\n", samples);

	audio::encode_to(audio::float_32, mixbuf, 2, samples, outbuf, bytes);

	if(bytes != count*sizeof(float))
	{
		fprintf(stderr, "Something fishy with byte count.\n");
		return 2;
	}

	// Because the mixer buffer is destroyed (clipped&scaled)... repeat the whole procedure.
	audio::encode_from(audio::float_32, inbuf, count*sizeof(float), mixbuf, 2, samples);
	audio::encode_to(audio::signed_32, mixbuf, 2, samples, s32out, bytes);
	audio::encode_from(audio::float_32, inbuf, count*sizeof(float), mixbuf, 2, samples);
	audio::encode_to(audio::signed_16, mixbuf, 2, samples, s16out, bytes);

	printf("# sample clipping, float to float and others\n");
	printf("#in	out	s32	s16\n");
	for(size_t i=0; i<count; ++i)
	{
		printf("%g	%g	%li	%li\n", inbuf[i], outbuf[i], (long)s32out[i], (long)s16out[i]);
	}

	return 0;
}
